
<p align="center">
  <a href="https://hopeui.iqonic.design/?utm_source=github&utm_medium=github-description&utm_campaign=open_source_github" target="__blank" title="Hope UI">
    <img src="https://assets.iqonic.design/hope-ui/github/logo.png" />
  </a>
</p>
<p align="center">
<a href="https://github.com/iqonicdesignofficial/hope-ui-design-system/" target="__blank"><img src="https://img.shields.io/github/stars/iqonicdesignofficial/hope-ui-design-system" /> </a>
<a href="https://github.com/iqonicdesignofficial/hope-ui-design-system/network" target="__blank"><img src="https://img.shields.io/github/forks/iqonicdesignofficial/hope-ui-design-system" /> </a>
<a href="https://github.com/iqonicdesignofficial/hope-ui-design-system/issues" target="__blank"><img src="https://img.shields.io/github/issues/iqonicdesignofficial/hope-ui-design-system" /> </a>
<a href="#" target="__blank"><img src="https://img.shields.io/bower/v/editor.md.svg" /> </a>
<a href="https://github.com/iqonicdesignofficial/hope-ui-design-system/blob/main/LICENSE" target="__blank"><img src="https://img.shields.io/github/license/iqonicdesignofficial/hope-ui-design-system" /> </a>
<a href="https://twitter.com/iqonicdesign" target="__blank"><img src="https://img.shields.io/twitter/url?style=social&url=https%3A%2F%2Ftwitter.com%2Fiqonicdesign" /></a>
</p>
<h3 align="center">Free Open Source Bootstrap 5 Design System.</h3>
<p align="center">
  <a href="https://templates.iqonic.design/hope-ui/html/dist" title="Hope UI"><strong>Live Demo</strong></a>
  <span>|</span>
  <a href="https://www.figma.com/community/file/1009728454881721702" title="Hope UI"><strong>Figma UI Kit</strong></a>
  <span>|</span>
  <a href="https://iqonic.design/product/admin-templates/hope-ui-admin-free-open-source-bootstrap-admin-template/?utm_source=github&utm_medium=github-description&utm_campaign=open_source_github" title="Hope UI"><strong>HTML Dashboard</strong></a>
  <span>|</span>
  <a href="https://iqonic.design/product/admin-templates/hope-ui-open-source-vue-js-admin-template/?utm_source=github&utm_medium=github-description&utm_campaign=open_source_github" title="Hope UI"><strong>Vue JS Dashboard</strong></a>
  <span>|</span>
  <a href="https://iqonic.design/product/admin-templates/hope-ui-free-open-source-react-admin-template/?utm_source=github&utm_medium=github-description&utm_campaign=open_source_github" title="Hope UI"><strong>React JS Dashboard</strong></a>
  <span>|</span>
  <a href="https://iqonic.design/product/admin-templates/hope-ui-free-open-source-laravel-admin-panel/?utm_source=github&utm_medium=github-description&utm_campaign=open_source_github" title="Hope UI"><strong>Laravel Dashboard</strong></a>
</p>

------------

<a href="https://templates.iqonic.design/hope-ui/html/dist" target="__blank" title="Hope UI Dashboard">
  <img src="https://assets.iqonic.design/hope-ui/github/rtl-mode-min.png" alt="Hope UI Dashboard" />
</a>

Hope UI – free open source Bootstrap Design System is a gorgeously built UI kit based on bootstrap 5. The best free Bootstrap 5 design system is fully responsive and user-friendly, allowing Hope UI users to work effortlessly.
Being easily adaptable and flexible, Hope UI can be a go-to design system for the developer out there.

Looking up to creating a new application for a personal project or client? Hope UI – free open source Bootstrap design system can help build a robust and understandable admin dashboard or website without spending much time designing the whole thing from scratch.

### What Can You Do with The Hope UI

Hope UI is packed with finely-crafted UI elements, multiple styles of Menu, a set of graphs, charts, and animated icons.
Built ideally for developers, designers, and startups, or Creators, Hope UI brings design consistency and acts as a strong foundation to manage a successful web or app project.

### 5 Irresistible Reasons To Have Hope UI
- Unlike any other Design System, Hope UI is fully responsive which facilitates business owners to view the admin panel right from their mobile screens without losing the resolution.
- With the purpose of data presentation, this best free Bootstrap 5 design system comes with extensive elements and widgets to add texts and images. 
- Besides being super easy and rapidly adaptable features, Hope UI is the cost-effective way to control and overview web or app project performance with a pre-coded design system and examples.
- Hope UI is a strongly built system, a layout that focuses on both the scalability and performance of the project.
- Hope UI Packs 100+ Fully-Codes Elements and widgets backed with SCSS and Gulp to make the development easy and fast.


### Features

- Support with bootstrap 5
- Scss component based design
- Fully Responsive
- Clean Code
- Demo Pages
- Color Mode
- Working auth page
- Direction Mode
- Layout Setting
- 30+ Menu Styles

<a href="https://www.youtube.com/watch?v=3OMj6nqDuAA" title="Hope UI" target="__blank">
  <img src="https://assets.iqonic.design/hope-ui/github/hope-ui-youtube.png" alt="Hope UI Video" />
</a>

# Table of Contents

  - [Quick Start](#quick-start)
    - [Method 1: Direct Download](#method-1-direct-download)
    - [Method 2: Using CDN](#method-2-using-cdn)
    - [Method 3: Using NPM](#method-3-using-npm)
  - [Documentation](#documentation)
  - [Version](#version)
  - [Public RoadMap](#public-roadmap)
  - [File Structure](#file-structure)
  - [Browser Support](#browser-support)
  - [Don't Buy a Coffee for Us Instead Support Us](#dont-buy-a-coffee-for-us-instead-support-us)
  - [More from Iqonic Design](#more-from-iqonic-design)
  - [Reporting Issues](#reporting-issues)
  - [Special Thanks](#special-thanks)
  - [Change Log](#change-log)
  - [Follow Us](#follow-us)
  - [Licensing](#licensing)

## Quick Start

You can use following method to get started with CSS and JS files of the design system.

### Method 1: Direct Download
[Dowload from Github](https://github.com/tafcoder/sleek-dashboard/archive/refs/heads/master.zip)

[Download from Iqonic Design](https://iqonic.design/product/admin-templates/hope-ui-admin-free-open-source-bootstrap-admin-template/?utm_source=github&utm_medium=github-description&utm_campaign=open_source_github)
### Method 2: Using CDN
```
<link href="https://cdn.jsdelivr.net/gh/iqonicdesignofficial/hope-ui-design-system@main/dist/assets/css/hope-ui.min.css" rel="stylesheet"/>
```

```
<script src="https://cdn.jsdelivr.net/gh/iqonicdesignofficial/hope-ui-design-system@main/dist/assets/js/hope-ui.js"></script>
```
### Method 3: Using NPM
Start working with the design system
1. Install node_modules Run in terminal or CMD:
```
npm install
```

2. Install vendor Run in terminal or CMD: 
```
composer install
```
3. To build css and js for Run in terminal or CMD:
```
npm run dev
```
4. Generate Key for project in terminal or CMD:
```
cp .env.example .env

php artisan key:generate
```
5. To run the project:
```
php artisan serve
```
[More Details...](https://templates.iqonic.design/hope-ui/documentation/html/dist/main/gulp.html)
## Documentation
You can find our documentation [here](https://templates.iqonic.design/hope-ui/documentation/html/dist/main/).

## Version
- [Figma](https://www.figma.com/community/file/1009728454881721702)
- [HTML Admin Dashboard](https://iqonic.design/product/admin-templates/hope-ui-admin-free-open-source-bootstrap-admin-template/?utm_source=github&utm_medium=github-description&utm_campaign=open_source_github)
- [Vue JS Dashobard](https://iqonic.design/product/admin-templates/hope-ui-open-source-vue-js-admin-template/?utm_source=github&utm_medium=github-description&utm_campaign=open_source_github)
- [React JS Dashobard](https://iqonic.design/product/admin-templates/hope-ui-free-open-source-react-admin-template/?utm_source=github&utm_medium=github-description&utm_campaign=open_source_github)
- [Laravel Dashobard](https://iqonic.design/product/admin-templates/hope-ui-free-open-source-laravel-admin-panel/?utm_source=github&utm_medium=github-description&utm_campaign=open_source_github)

## Public RoadMap
Checkout our public roadmap of Hope UI and also submit features requests [here](https://iqonic.design/hopeui-roadmap/).
## File Structure
Within the download you'll find the following directories and files, logically grouping common assets and providing both compiled and minified variations. You'll see something like this:
```
github/hope-ui-admin-dashboard/
laravel
    ├── app
    │    ├── Console
    │    ├── Exceptions
    │    ├── Helpers
    │    ├── Http
    │    │    ├── Controllers
    |    |    |     ├── Auth
    |    |    |     ├── security
    │    |    |     ├── Controller.php
    │    |    |     ├── UserController.php
    │    |    |     └── HomeController.php
    │    │    ├── Middleware
    │    │    └── lRequests
    │    ├── Model
    │    ├── Provider
    │    └── View
    ├── bootstrap
    ├── config
    ├── database
    ├── node_modelus
    ├── public
    │    ├── images
    │    │    ├── icon.png
    │    │    ├── favicon.ico
    │    │    └── loader.gif
    │    ├── js
    |    │    ├── slider-tabs.js
    |    │    ├── countdown.js
    |    |    └── prism.min.js
    │    └── scss
    │        ├── bootstrap/
    │        │     ├── forms/
    │        │     ├── helper/
    │        │     ├── mixins/
    │        │     ├── utilites/
    │        │     └── vendor/
    │        ├── custom
    │        │     ├── auth/
    │        │     ├── kanban/
    │        │     ├── pricing/
    │        │     └── ui-kit/
    │        ├── hope-ui-design-system
    │        │     ├── components/
    │        │     ├── helper/
    │        │     ├── layout-style/
    │        │     ├── pages/
    │        │     ├── plugins/
    │        │     ├── variables/
    │        │     └── variables.scss
    │        ├── dark
    │        │     ├── components/
    │        │     ├── helper/
    │        │     ├── layout-style/
    │        │     ├── pages/
    │        │     ├── plugins/
    │        │     ├── reboot/
    │        │     ├── _dark.scss
    │        │     └── _index.scss
    │        ├── rtl
    │        │     ├── components/
    │        │     ├── pages/
    │        │     ├── reboot/
    │        │     ├── utilities/
    │        │     └── _index.scss
    │        ├── customizer
    │        │     ├── components/
    │        │     ├── layouts/
    │        │     ├── menu-style/
    │        │     ├── utilities/
    │        │     ├── _components.scss
    │        │     ├── _dark.scss
    │        │     ├── _layouts.scss
    │        │     ├── _reboot.scss
    │        │     ├── _root.scss
    │        │     └── _variables.scss
    │        ├── rtl.scss
    │        ├── dark.scss
    │        ├── custom.scss
    │        ├── customizer.scss
    │        └── hope-ui.scss
    ├── resources
    |    ├── css
    |    ├── js
    |    ├── lang
    |    ├── sass
    |    └── views
    │         ├── app
    │         ├── auth
    │         ├── chart
    │         ├── components
    │         ├── dashboards
    │         ├── extrapages
    │         ├── forms
    │         ├── icons
    │         ├── layouts
    │         ├── pageError
    │         ├── partial
    │         ├── table
    │         ├── timeline
    │         ├── ui
    │         ├── role-permission
    │         ├── dashboard.blade.php
    |         └── welcome.blade.php
    ├── route
    ├── tests
    ├── .editorconfig
    ├── .env.example
    ├── .styleci.yml
    ├── artisan
    ├── composer.json
    ├── package.json
    ├── phpunit.xml
    ├── README.md
    ├── server.php
    └── webpack.mix.js
```

## Browser Support
![chrome](https://assets.iqonic.design/hope-ui/github/chrome.png)
![Firefox](https://assets.iqonic.design/hope-ui/github/Firefox.png)
![Safari](https://assets.iqonic.design/hope-ui/github/Safari.png)
![Microsoft](https://assets.iqonic.design/hope-ui/github/Microsoft%20edge.png)
![Operamini](https://assets.iqonic.design/hope-ui/github/Operamini.png)

## Don't Buy a Coffee for Us Instead Support Us
- Star our GitHub repo ⭐
- [Tweet about it](https://twitter.com/intent/tweet?text=Checkout%20%23HopeUI%20%E2%80%93%20Amazing%20open-source%20Bootstrap%205%20Admin%20Dashboard%20%26%20Design%20system.%20%23BuildwithHopeUI&url=https%3A%2F%2Fbit.ly%2F3ANB7gT).
- Submit bugs, or suggest new features and documentation updates 🔧
- Follow [@iqonicdesign](https://twitter.com/iqonicdesign) on Twitter.
- Follow Us on [Instagram](https://www.instagram.com/iqonicdesign/)
- Subscribe to Iqonic newsletter at [iqonic.design](https://iqonic.design)

## More from Iqonic Design
- [Free Products Every Week](https://iqonic.design/?utm_source=github&utm_medium=github-description&utm_campaign=open_source_github)
- [Premium Themes, templates, dashbaords, Apps, and more](https://iqonic.design/shop/?iqonic=1&orderby=sales&paged=1&product_for=premium)
- [Subscribe on Youtube](https://www.youtube.com/c/IqonicDesign)
- [Reach US](https://iqonic.design/contact-us/)
## Reporting Issues
Have a bug or a feature request? Raise a new issue at our [github](https://github.com/iqonicdesignofficial/hope-ui-design-system/issues) support

## Special Thanks
- [Bootstrap](https://getbootstrap.com/)
- [Google Fonts](https://www.google.com/fonts)
- [Jquery](https://jquery.com/)
- [Apex Charts](https://apexcharts.com/)
[Checkout complete list](https://templates.iqonic.design/hope-ui/documentation/html/dist/main/sourceAndCredit.html)

## Change Log
[Click Here](https://templates.iqonic.design/hope-ui/documentation/html/dist/main/change-log.html) to check our full change log.
## Follow Us
- [Twitter](https://twitter.com/iqonicdesign)
- [Facebook](https://www.facebook.com/iqonicdesign/)
- [Dribbble](https://dribbble.com/IqonicDesign)
- [Instagram](https://www.instagram.com/iqonicdesign/)
- [Product Hunt](https://www.producthunt.com/posts/iqonic-design)
## Licensing
- Code and Documentation Copyright 2021 All Rights Reserved by [IQONIC](https://iqonic.design/?utm_source=github&utm_medium=github-description&utm_campaign=open_source_github) Design. Code released under the [MIT](https://iqonic.design/licenses/) License.