<?php

namespace App\Exports;

use App\Models\Parties;
use App\Models\Transaction;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class PartyExport implements FromCollection, WithHeadings
{
    protected $ids;

    public function __construct(array $ids)
    {
        $this->ids = $ids;
    }

    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        return Transaction::whereIn('id', $this->ids)
            ->with(['party'])
            ->get()
            ->map(function ($transaction) {
                return [
                    'ID' => $transaction->id,
                    'Party' => $transaction->party->name,
                    'Sender City' => $transaction->sender_city ?? '',
                    'Receiver City' => $transaction->receiver_city ?? '',
                    'Amount' => $transaction->amount,
                ];
            });
    }

    public function headings(): array
    {
        return ['ID', 'Party', 'Sender City', 'Receiver City', 'Amount'];
    }
}
