<?php

namespace App\Exports;

use App\Models\Transaction;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class TransactionsExport implements FromCollection, WithHeadings
{
    protected $ids;

    public function __construct(array $ids)
    {
        $this->ids = $ids;
    }
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        return Transaction::whereIn('id', $this->ids)
            ->with(['senderUser', 'receiverUser'])
            ->get()
            ->map(function ($transaction) {
                return [
                    'ID' => $transaction->id,
                    'Sender' => $transaction->senderUser->first_name . ' ' . $transaction->senderUser->last_name ?? '',
                    'Receiver' => $transaction->receiverUser->first_name . ' ' . $transaction->receiverUser->last_name ?? '',
                    'Sender City' => $transaction->sender_city ?? '',
                    'Receiver City' => $transaction->receiver_city ?? '',
                    'Amount' => $transaction->amount,
                ];
            });
    }

    public function headings(): array
    {
        return ['ID', 'Sender', 'Receiver', 'Sender City', 'Receiver City', 'Amount'];
    }
}
