<?php

namespace App\Http\Controllers;

use App\Models\Account;
use App\Models\User;
use Illuminate\Http\Request;

class AccountController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $accounts = Account::with('user')->get();

        if ($request->wantsJson()) {
            return response()->json(['status' => true, 'accounts' => $accounts]);
        }

        return view('accounts.index', compact('accounts'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id, Request $request)
    {
        $account = Account::findOrFail($id);
        $account->delete();

        if ($request->wantsJson()) {
            return response()->json(['status' => true, 'message' => 'Account Deleted Successfully', 'account' => $account]);
        }

        return redirect()->route('accounts.index')->with('success','Account Deleted successfully');
    }

    public function settle(string $id)
    {
        $account = Account::findOrFail($id);
        $account->balance = 0.00;
        $account->save();

        return response()->json([
            'status' => 'success',
            'message' => 'Account settled successfully!',
        ]);
    }
}
