<?php

namespace App\Http\Controllers;

use App\Models\Commission;
use App\Models\MyCommission;
use App\Models\Parties;
use App\Models\User;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    public function getTotalUsers()
    {
        $userCount = User::count();

        return response()->json([
            'total_users' => $userCount
        ]);
    }

    public function getTotalParties()
    {
        $partyCount = Parties::count();

        return response()->json([
            'total_parties' => $partyCount
        ]);
    }

    public function showTotalUsers()
    {
        $userCount = User::count();
        return view('dashboard', compact('userCount'));
    }

    public function getTotalMyCommissions()
    {
        $totalMyCommissions = MyCommission::sum('my_commission');
        return response()->json([
            'total_my_commissions' => $totalMyCommissions
        ]);
    }

    public function getTotalCommissions()
    {
        $totalCommissions = Commission::sum('total_commission');
        return response()->json([
            'total_commissions' => $totalCommissions
        ]);
    }
}
