<?php

namespace App\Http\Controllers;

use App\Models\MyCommission;
use App\Models\Parties;
use Illuminate\Http\Request;

class MyCommissionController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $query = MyCommission::with(['senderUser', 'receiverUser', 'party']);

        if ($request->filled('party')) {
            $query->where('parties_id', $request->party);
        }

        if ($request->filled('date')) {
            $query->whereDate('date', $request->date);
        }

        if ($request->filled('sender_city')) {
            $query->where('sender_city', 'LIKE', '%' . $request->sender_city . '%');
        }

        if ($request->filled('receiver_city')) {
            $query->where('receiver_city', 'LIKE', '%' . $request->receiver_city . '%');
        }

        $mycommissions = $query->get(); // Fetch data after filtering

        $parties = Parties::all();

        if ($request->wantsJson()) {
            return response()->json(['status' => true, 'mycommissions' => $mycommissions]);
        }

        return view('mycommissions.index', compact('mycommissions', 'parties'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id, Request $request)
    {
        $mycommission = MyCommission::findOrFail($id);
        $mycommission->delete();

        if ($request->wantsJson()) {
            return response()->json(['status' => true, 'message' => 'My Commission Deleted Successfully', 'mycommission' => $mycommission]);
        }

        return redirect()->route('mycommissions.index')->with('success','My Commission Deleted successfully');
    }

    public function bulkDestroy(Request $request)
    {
        $ids = json_decode($request->ids, true);
        if (!empty($ids)) {
            MyCommission::whereIn('id', $ids)->delete();
            return redirect()->route('mycommissions.index')->with('success', 'Selected my commissions deleted successfully.');
        }
        return back()->with('error', 'No records selected.');
    }
}
