<?php

namespace App\Http\Controllers;

use App\Models\Parties;
use App\Models\PartiesCommission;
use Illuminate\Http\Request;

class PartiesCommissionController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $query = PartiesCommission::with(['senderUser', 'receiverUser', 'party']);

        if ($request->filled('party')) {
            $query->where('parties_id', $request->party);
        }

        if ($request->filled('date')) {
            $query->whereDate('date', '=', $request->date);
        }

        if ($request->filled('sender_city')) {
            $query->where('sender_city', 'LIKE', '%' . $request->sender_city . '%');
        }

        if ($request->filled('receiver_city')) {
            $query->where('receiver_city', 'LIKE', '%' . $request->receiver_city . '%');
        }

        $partiescommissions = $query->get();

        $parties = Parties::all();

        if ($request->wantsJson()) {
            return response()->json(['status' => true, 'partiescommissions' => $partiescommissions]);
        }

        return view('partiescommissions.index', compact('partiescommissions', 'parties'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id, Request $request)
    {
        $partiescommission = PartiesCommission::findOrFail($id);
        $partiescommission->delete();

        if ($request->wantsJson()) {
            return response()->json(['status' => true, 'message' => 'Parties Commission Deleted Successfully', 'partiescommission' => $partiescommission]);
        }

        return redirect()->route('partiescommissions.index')->with('success','Parties Commission Deleted successfully');
    }

    public function bulkDestroy(Request $request)
    {
        $ids = json_decode($request->ids, true);
        // echo '<pre>';print_r($ids);exit;
        if (!empty($ids)) {
            PartiesCommission::whereIn('id', $ids)->delete();
            return redirect()->route('partiescommissions.index')->with('success', 'Selected parties commissions deleted successfully.');
        }
        return back()->with('error', 'No records selected.');
    }
}
