<?php

namespace App\Http\Controllers;

use App\Models\Parties;
use Illuminate\Http\Request;

class PartiesController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $parties = Parties::all();

        if ($request->wantsJson()) {
            return response()->json(['status' => true, 'parties' => $parties]);
        }

        return view('parties.index', compact('parties'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('parties.addedit');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $party = new Parties();
        $party->name = $request->input('name');
        $party->email = $request->input('email');
        $party->phone_number = $request->input('phone_number');
        $party->parties_commission = $request->input('parties_commission');
        // echo '<pre>';print_r($party);exit;
        $party->save();

        if ($request->wantsJson()) {
            return response()->json(['status' => true, 'message' => 'Party Created Successfully', 'party' => $party]);
        }

        return redirect()->route('parties.index')->with('success', 'Party Created successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    public function partyShow($id)
    {
        $party = Parties::find($id);
        if (!$party) {
            return response()->json(['error' => 'Party not found'], 404);
        }
        return response()->json($party);
    }

    public function partyUpdate(Request $request, $id)
    {
        try {
            $party = Parties::find($id);
            if (!$party) {
                return response()->json(['status' => false, 'message' => 'Party not found'], 404);
            }

            $validated = $request->validate([
                'name' => 'required|string|max:255',
                'email' => 'required|email|unique:parties,email,' . $id,
                'phone_number' => 'required|string|max:15',
                'parties_commission' => 'required|',
            ]);

            $party->update($validated);

            return response()->json([
                'status' => true,
                'message' => 'Party updated successfully',
                'party' => $party
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'status' => false,
                'message' => 'Error updating party',
                'error' => $e->getMessage()
            ], 500);
        }
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id, Request $request)
    {
        $party = Parties::findOrFail($id);

        // echo '<pre>';print_r($party);exit;
        if ($request->wantsJson()) {
            return response()->json(['status' => true, 'party' => $party]);
        }

        return view('parties.addedit', compact('party', 'id'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        // dd($request->all());
        $party = Parties::findOrFail($id);
        $party->name = $request->input('name');
        $party->email = $request->input('email');
        $party->phone_number = $request->input('phone_number');
        $party->parties_commission = $request->input('parties_commission');
        $party->save();

        if ($request->wantsJson()) {
            return response()->json(['status' => true, 'message' => 'Party Updated Successfully', 'party' => $party]);
        }

        return redirect()->route('parties.index')->with('success', 'Party Updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id, Request $request)
    {
        $party = Parties::findOrFail($id);
        $party->delete();

        if ($request->wantsJson()) {
            return response()->json(['status' => true, 'message' => 'Party Deleted Successfully', 'party' => $party]);
        }

        return redirect()->route('users.index')->with('success','Party Deleted successfully');
    }
}
