<?php

namespace App\Http\Controllers;

use App\Models\SetCommission;
use Illuminate\Http\Request;

class SetCommissionController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $setcommissions = SetCommission::all();

        if ($request->wantsJson()) {
            return response()->json(['status' => true, 'setcommissions' => $setcommissions]);
        }

        return view('setcommissions.index', compact('setcommissions'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('setcommissions.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $setcommission = new SetCommission();
        $setcommission->amount = $request->input('amount');
        $setcommission->percentage_fix = $request->input('percentage_fix');
        $setcommission->percentage_fix_amount = $request->input('percentage_fix_amount');
        // echo '<pre>';print_r($setcommission);exit;
        $setcommission->save();

        if ($request->wantsJson()) {
            return response()->json(['status' => true, 'message' => 'Set Commission Created Successfully', 'setcommission' => $setcommission]);
        }

        return redirect()->route('setcommissions.index')->with('success', 'Set Commission Created Successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    public function setcommissionShow($id)
    {
        $setcommission = SetCommission::find($id);
        if (!$setcommission) {
            return response()->json(['error' => 'Set Commission not found'], 404);
        }
        return response()->json($setcommission);
    }

    public function setcommissionUpdate(Request $request, $id)
    {
        try {
            $setcommission = SetCommission::find($id);
            if (!$setcommission) {
                return response()->json(['status' => false, 'message' => 'Set Commission not found'], 404);
            }

            $validated = $request->validate([
                'amount' => 'required|string|max:255',
                'percentage_fix' => 'required|string|max:255',
                'percentage_fix_amount' => 'required|string|max:15',
            ]);

            $setcommission->update($validated);

            return response()->json([
                'status' => true,
                'message' => 'Set Commission updated successfully',
                'setcommission' => $setcommission
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'status' => false,
                'message' => 'Error updating set commission',
                'error' => $e->getMessage()
            ], 500);
        }
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $setCommission = SetCommission::findOrFail($id);
        return view('setcommissions.edit', compact('setCommission'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $setcommission = SetCommission::findOrFail($id);
        $setcommission->amount = $request->input('amount');
        $setcommission->percentage_fix = $request->input('percentage_fix');
        $setcommission->percentage_fix_amount = $request->input('percentage_fix_amount');
        // echo '<pre>';print_r($setcommission);exit;
        $setcommission->save();

        if ($request->wantsJson()) {
            return response()->json(['status' => true, 'message' => 'Set Commission Updated Successfully', 'setcommission' => $setcommission]);
        }

        return redirect()->route('setcommissions.index')->with('success', 'Set Commission Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id, Request $request)
    {
        $setcommission = SetCommission::findOrFail($id);
        $setcommission->delete();

        if ($request->wantsJson()) {
            return response()->json(['status' => true, 'message' => 'Set Commission Deleted Successfully', 'setcommission' => $setcommission]);
        }

        return redirect()->route('setcommissions.index')->with('success','Set Commission Deleted successfully');
    }
}
