<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Reports extends Model
{
    use HasFactory;

    protected $fillable = [
        'users_id',
        'parties_id	',
        'amount',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function senderUser()
    {
        return $this->belongsTo(User::class, 'sender', 'id');
    }

    public function receiverUser()
    {
        return $this->belongsTo(User::class, 'receiver', 'id');
    }

    public function party()
    {
        return $this->belongsTo(Parties::class, 'parties_id');
    }
}
