<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Laravel\Sanctum\HasApiTokens;

class Transaction extends Model
{
    use HasFactory, HasApiTokens;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'sender',
        'receiver',
        'party',
        'amount',
        'sender_city',
        'receiver_city',
        'date',
        'commission_paid_by',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function senderUser()
    {
        return $this->belongsTo(User::class, 'sender', 'id');
    }

    public function receiverUser()
    {
        return $this->belongsTo(User::class, 'receiver', 'id');
    }

    public function party()
    {
        return $this->belongsTo(Parties::class, 'parties_id');
    }
}
