<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('sender')->constrained('users')->onDelete('cascade');
            $table->foreignId('receiver')->constrained('users')->onDelete('cascade');
            $table->decimal('amount', 15, 2);
            $table->string('city');
            $table->date('date');
            $table->foreignId('parties_id')->constrained('parties')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
