<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('commissions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('sender')->constrained('users')->onDelete('cascade');
            $table->foreignId('receiver')->constrained('users')->onDelete('cascade');
            $table->foreignId('parties_id')->constrained('parties')->onDelete('cascade');
            $table->date('date');
            $table->decimal('amount', 15, 2);
            $table->decimal('percentage', 5, 2);
            $table->decimal('fix_amount', 15, 2);
            $table->decimal('parties_commission', 15, 2);
            $table->decimal('my_commission', 15, 2);
            $table->decimal('total_commission', 15, 2);
            $table->string('sender_city');
            $table->string('receiver_city');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('commissions');
    }
};
