<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('parties_commissions', function (Blueprint $table) {
            $table->id();
            $table->string('sender');
            $table->string('receiver');
            $table->unsignedBigInteger('parties_id');
            $table->date('date');
            $table->decimal('amount', 10, 2);
            $table->decimal('party_commission', 10, 2);
            $table->string('sender_city');
            $table->string('receiver_city');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('parties_commissions');
    }
};
