<x-app-layout :assets="$assets ?? []">
    <div>
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <form method="GET" action="{{ route('partiescommissions.index') }}">
                        <div class="row" style="margin-left: 15px; margin: 10px;">
                            <div class="col-md-2">
                                <label for="party" class="form-label">Party</label>
                                <select name="party" id="party" class="form-control">
                                    <option value="">All</option>
                                    @foreach ($parties as $party)
                                        <option value="{{ $party->id }}" {{ request('party') == $party->id ? 'selected' : '' }}>
                                            {{ $party->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-2">
                                <label for="date" class="form-label">Date</label>
                                <input type="date" name="date" id="date" class="form-control" value="{{ request('date') }}">
                            </div>
                            <div class="col-md-2">
                                <label for="sender_city" class="form-label">Sender City</label>
                                <input type="text" name="sender_city" id="sender_city" class="form-control" placeholder="Enter sender city" value="{{ request('sender_city') }}">
                            </div>
                            <div class="col-md-2">
                                <label for="receiver_city" class="form-label">Receiver City</label>
                                <input type="text" name="receiver_city" id="receiver_city" class="form-control" placeholder="Enter receiver city" value="{{ request('receiver_city') }}">
                            </div>
                            <div class="col-md-2 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary">Filter</button>
                                <a href="{{ route('transactions.index') }}" class="btn btn-secondary ms-2">Reset</a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <div class="header-title">
                            <h4 class="card-title">Party Commissions List</h4>
                        </div>
                        <div class="card-action">
                            <form id="bulk-delete-form" action="{{ route('partiescommissions.bulkDestroy') }}" method="POST">
                                @csrf
                                @method('DELETE')
                                <input type="hidden" name="ids" id="bulk-delete-ids">
                                <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete selected records?');">Bulk Delete</button>
                            </form>
                        </div>
                    </div>
                    <div class="card-body px-0">
                        <div class="table-responsive">
                            <table class="table table-bordered" role="grid" data-toggle="data-table">
                                <thead>
                                    <tr class="ligth">
                                        <th style="text-align: center"><input type="checkbox" id="select-all"></th>
                                        <th style="text-align: center">ID</th>
                                        <th style="text-align: center">Sender</th>
                                        <th style="text-align: center">Receiver</th>
                                        <th style="text-align: center">Party</th>
                                        <th style="text-align: center">Date</th>
                                        <th style="text-align: center">Amount</th>
                                        <th style="text-align: center">Party Commission</th>
                                        <th style="text-align: center">Sender City</th>
                                        <th style="text-align: center">Receiver City</th>
                                        <th style="min-width: 100px; text-align:center;">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($partiescommissions as $pc)
                                        <tr>
                                            <td class="text-center">
                                                <input type="checkbox" class="record-checkbox" value="{{ $pc->id }}">
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $pc->id ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $pc->senderUser->first_name ?? '' }} {{ $pc->senderUser->last_name ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $pc->receiverUser->first_name ?? '' }} {{ $pc->receiverUser->last_name ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $pc->party->name ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $pc->date ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $pc->amount ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $pc->party_commission ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $pc->sender_city ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $pc->receiver_city ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <div class="flex align-items-center list-user-action">
                                                    {{-- <a class="btn btn-sm btn-icon btn-warning" data-toggle="tooltip" data-placement="top" title="Edit" data-original-title="Edit" href="{{ route('partiescommissions.edit', $pc->id) }}">
                                                        <span class="btn-inner">
                                                            <svg width="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                <path d="M11.4925 2.78906H7.75349C4.67849 2.78906 2.75049 4.96606 2.75049 8.04806V16.3621C2.75049 19.4441 4.66949 21.6211 7.75349 21.6211H16.5775C19.6625 21.6211 21.5815 19.4441 21.5815 16.3621V12.3341" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                                                <path fill-rule="evenodd" clip-rule="evenodd" d="M8.82812 10.921L16.3011 3.44799C17.2321 2.51799 18.7411 2.51799 19.6721 3.44799L20.8891 4.66499C21.8201 5.59599 21.8201 7.10599 20.8891 8.03599L13.3801 15.545C12.9731 15.952 12.4211 16.181 11.8451 16.181H8.09912L8.19312 12.401C8.20712 11.845 8.43412 11.315 8.82812 10.921Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                                                <path d="M15.1655 4.60254L19.7315 9.16854" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                                            </svg>
                                                        </span>
                                                    </a> --}}
                                                    <form action="{{ route('partiescommissions.destroy', $pc->id) }}" method="POST" style="display:inline;">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-sm btn-icon btn-danger" data-toggle="tooltip" data-placement="top" title="Delete" onclick="return confirm('Are you sure you want to delete?');">
                                                            <span class="btn-inner">
                                                                <svg width="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" stroke="currentColor">
                                                                    <path d="M19.3248 9.46826C19.3248 9.46826 18.7818 16.2033 18.4668 19.0403C18.3168 20.3953 17.4798 21.1893 16.1088 21.2143C13.4998 21.2613 10.8878 21.2643 8.27979 21.2093C6.96079 21.1823 6.13779 20.3783 5.99079 19.0473C5.67379 16.1853 5.13379 9.46826 5.13379 9.46826" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                                                    <path d="M20.708 6.23975H3.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                                                    <path d="M17.4406 6.23973C16.6556 6.23973 15.9796 5.68473 15.8256 4.91573L15.5826 3.69973C15.4326 3.13873 14.9246 2.75073 14.3456 2.75073H10.1126C9.53358 2.75073 9.02558 3.13873 8.87558 3.69973L8.63258 4.91573C8.47858 5.68473 7.80258 6.23973 7.01758 6.23973" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                                                </svg>
                                                            </span>
                                                        </button>
                                                    </form>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>

<!-- jQuery (already included) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- jQuery UI CSS -->
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">

<!-- jQuery UI Script -->
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
<script>
    document.getElementById('select-all').addEventListener('change', function () {
        let checkboxes = document.querySelectorAll('.record-checkbox');
        checkboxes.forEach(checkbox => checkbox.checked = this.checked);
    });

    document.getElementById('bulk-delete-form').addEventListener('submit', function (e) {
        e.preventDefault(); // Prevent default form submission

        let selectedIds = [];
        document.querySelectorAll('.record-checkbox:checked').forEach(checkbox => {
            selectedIds.push(checkbox.value);
        });

        if (selectedIds.length === 0) {
            alert('No records selected.');
            return;
        }

        document.getElementById('bulk-delete-ids').value = JSON.stringify(selectedIds);
        this.submit(); // Proceed with form submission
    });

    $(function () {
        var cities = [
            "Ahmedabad", "Agra", "Ajmer", "Aligarh", "Allahabad", "Amritsar",
            "Bangalore", "Bhopal", "Bhubaneswar", "Chandigarh", "Chennai",
            "Coimbatore", "Dehradun", "Delhi", "Faridabad", "Gandhinagar",
            "Ghaziabad", "Guwahati", "Hyderabad", "Indore", "Jaipur", "Jodhpur",
            "Kanpur", "Kochi", "Kolkata", "Lucknow", "Ludhiana", "Meerut",
            "Mumbai", "Mysore", "Nagpur", "Nashik", "Noida", "Patna", "Pune",
            "Raipur", "Rajkot", "Ranchi", "Surat", "Thane", "Udaipur", "Vadodara",
            "Varanasi", "Vijayawada", "Visakhapatnam"
        ];

        $("#sender_city, #receiver_city").autocomplete({
            source: function(request, response) {
                var term = request.term.toLowerCase();
                var filteredResults = $.grep(cities, function(city) {
                    return city.toLowerCase().startsWith(term);
                });
                response(filteredResults);
            }
        });
    });
</script>
