<x-app-layout :assets="$assets ?? []">
    <div>
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <form method="GET" action="{{ route('reports.index') }}">
                        <div class="row" style="margin-left: 15px; margin: 10px;">
                            <div class="col-md-2">
                                <label for="party" class="form-label">Party</label>
                                <select name="party" id="party" class="form-control">
                                    <option value="">All</option>
                                    @foreach ($parties as $party)
                                        <option value="{{ $party->id }}" {{ request('party') == $party->id ? 'selected' : '' }}>
                                            {{ $party->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-2">
                                <label for="date" class="form-label">From Date</label>
                                <input type="date" name="date" id="date" class="form-control" value="{{ request('date') }}">
                            </div>
                            <div class="col-md-2">
                                <label for="date" class="form-label">To Date</label>
                                <input type="date" name="date" id="date" class="form-control" value="{{ request('date') }}">
                            </div>
                            <div class="col-md-2 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary">Filter</button>
                                <a href="{{ route('reports.index') }}" class="btn btn-secondary ms-2">Reset</a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <div class="header-title">
                            <h4 class="card-title">Party Reports List</h4>
                        </div>
                        <div class="card-action">
                            <form id="bulk-delete-form" action="{{ route('reports.bulkDestroy') }}" method="POST">
                                @csrf
                                @method('DELETE')
                                <input type="hidden" name="ids" id="bulk-delete-ids">
                                <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete selected records?');">Bulk Delete</button>
                                <a href="#" class="btn btn-sm btn-warning" id="export-pdf">Export as PDF</a>
                                <a href="#" class="btn btn-sm btn-success" id="export-excel">Export as Excel</a>
                            </form>
                        </div>
                    </div>
                    <div class="card-body px-0">
                        <div class="table-responsive">
                            <table class="table table-bordered" role="grid" data-toggle="data-table">
                                <thead>
                                    <tr class="ligth">
                                        <th style="text-align: center"><input type="checkbox" id="select-all"></th>
                                        <th style="text-align: center">ID</th>
                                        <th style="text-align: center">Party</th>
                                        <th style="text-align: center">Sedner City</th>
                                        <th style="text-align: center">Receiver City</th>
                                        <th style="text-align: center">Amount</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($reports as $report)
                                        <tr>
                                            <td class="text-center">
                                                <input type="checkbox" class="record-checkbox" value="{{ $report->id }}">
                                            </td>
                                            <td class="text-center">{{ $report->id ?? '' }}</td>
                                            <td class="text-center">{{ $report->party->name ?? '' }}</td>
                                            <td class="text-center">{{ $report->sender_city }}</td>
                                            <td class="text-center">{{ $report->receiver_city }}</td>
                                            <td class="text-center">{{ $report->amount ?? '' }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
<script>
    document.getElementById('select-all').addEventListener('change', function () {
        let checkboxes = document.querySelectorAll('.record-checkbox');
        checkboxes.forEach(checkbox => checkbox.checked = this.checked);
    });

    document.getElementById('bulk-delete-form').addEventListener('submit', function (e) {
        e.preventDefault();

        let selectedIds = [];
        document.querySelectorAll('.record-checkbox:checked').forEach(checkbox => {
            selectedIds.push(checkbox.value);
        });

        if (selectedIds.length === 0) {
            alert('No records selected.');
            return;
        }

        document.getElementById('bulk-delete-ids').value = JSON.stringify(selectedIds);
        this.submit();
    });

    document.getElementById('export-pdf').addEventListener('click', function (e) {
        e.preventDefault();

        let selectedIds = [];
        document.querySelectorAll('.record-checkbox:checked').forEach(checkbox => {
            selectedIds.push(checkbox.value);
        });

        if (selectedIds.length === 0) {
            alert('No records selected for export.');
            return;
        }

        let url = `{{ route('reports.partyexportpdf') }}?ids=` + selectedIds.join(',');
        window.open(url, '_blank');
    });

    document.getElementById('export-excel').addEventListener('click', function (e) {
        e.preventDefault();

        let selectedIds = [];
        document.querySelectorAll('.record-checkbox:checked').forEach(checkbox => {
            selectedIds.push(checkbox.value);
        });

        if (selectedIds.length === 0) {
            alert('No records selected for export.');
            return;
        }

        let url = `{{ route('reports.partyexportExcel') }}?ids=` + selectedIds.join(',');
        window.location.href = url;
    });
</script>
