<!DOCTYPE html>
<html>
<head>
    <title>Transactions Report</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            border: 1px solid black;
            padding: 8px;
            text-align: center;
        }
    </style>
</head>
<body>
    <h2 style="text-align: center;">Transactions Report</h2>
    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Sender</th>
                <th>Receiver</th>
                <th>Sender City</th>
                <th>Receiver City</th>
                <th>Amount</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($transactions as $transaction)
                <tr>
                    <td>{{ $transaction->id }}</td>
                    <td>{{ $transaction->senderUser->first_name ?? '' }} {{ $transaction->senderUser->last_name ?? '' }}</td>
                    <td>{{ $transaction->receiverUser->first_name ?? '' }} {{ $transaction->receiverUser->last_name ?? '' }}</td>
                    <td>{{ $transaction->sender_city }}</td>
                    <td>{{ $transaction->receiver_city }}</td>
                    <td>{{ $transaction->amount }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
