<x-app-layout :assets="$assets ?? []">
    <div class="row">
        <div class="col-xl-12 col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <div class="header-title">
                        <h4 class="card-title">Edit Set Commission</h4>
                    </div>
                    <div class="card-action">
                        <a href="{{ route('setcommissions.index') }}" class="btn btn-sm btn-primary" role="button">Back</a>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('setcommissions.update', $setCommission->id) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="new-user-info">
                            <div class="row">
                                <div class="form-group col-md-4">
                                    <label class="form-label" for="amount">Amount: <span class="text-danger">*</span></label>
                                    <select class="form-control" id="amount" name="amount" required>
                                        <option value="">Select Amount</option>
                                        <option value="0-100000" {{ $setCommission->amount == '0-100000' ? 'selected' : '' }}>0 - 100000</option>
                                        <option value="100000-500000" {{ $setCommission->amount == '100000-500000' ? 'selected' : '' }}>100000 - 500000</option>
                                        <option value="500000-above" {{ $setCommission->amount == '500000-above' ? 'selected' : '' }}>500000 and above</option>
                                    </select>
                                </div>
                                <div class="form-group col-md-4">
                                    <label class="form-label" for="percentage_fix">Percentage/Fix: <span class="text-danger">*</span></label>
                                    <select class="form-control" name="percentage_fix" id="percentage_fix" required>
                                        <option value="percentage" {{ $setCommission->percentage_fix == 'percentage' ? 'selected' : '' }}>Percentage</option>
                                        <option value="fix" {{ $setCommission->percentage_fix == 'fix' ? 'selected' : '' }}>Fix</option>
                                    </select>
                                </div>
                                <div class="form-group col-md-4">
                                    <label class="form-label" for="percentage_fix_amount">Percentage/Fix Amount: <span class="text-danger">*</span></label>
                                    <input class="form-control" type="text" placeholder="Enter Percentage/Fix Amount" id="percentage_fix_amount" name="percentage_fix_amount" value="{{ $setCommission->percentage_fix_amount }}" required>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-sm btn-primary">Update Set Commission</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
