<x-app-layout :assets="$assets ?? []">
    <div class="row">
        <div class="col-xl-12 col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <div class="header-title">
                        <h4 class="card-title">Create Transaction</h4>
                    </div>
                    <div class="card-action">
                        <a href="{{ route('transactions.index') }}" class="btn btn-sm btn-primary" role="button">Back</a>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('transactions.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="new-user-info">
                            <div class="row">
                                <div class="form-group col-md-4">
                                    <label class="form-label" for="sender">Sender: <span class="text-danger">*</span></label>
                                    <select class="form-control" name="sender" id="sender" required>
                                        <option value="">Select Sender</option>
                                        @foreach($users as $user)
                                            <option value="{{ $user->id }}">{{ $user->first_name }} {{ $user->last_name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group col-md-4">
                                    <label class="form-label" for="receiver">Receiver: <span class="text-danger">*</span></label>
                                    <select class="form-control" name="receiver" id="receiver" required>
                                        <option value="">Select Receiver</option>
                                        @foreach($users as $user)
                                            <option value="{{ $user->id }}">{{ $user->first_name }} {{ $user->last_name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group col-md-4">
                                    <label class="form-label" for="party">Party: <span class="text-danger">*</span></label>
                                    <select class="form-control" name="party" id="party" required>
                                        <option value="">Select Party</option>
                                        @foreach($parties as $party)
                                            <option value="{{ $party->id }}">{{ $party->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-md-4">
                                    <label class="form-label" for="amount">Amount: <span class="text-danger">*</span></label>
                                    <input class="form-control" type="number" placeholder="Enter Amount" id="amount" name="amount" required>
                                </div>
                                <div class="form-group col-md-4">
                                    <label class="form-label" for="sender_city">Sender City: <span class="text-danger">*</span></label>
                                    <input class="form-control" type="text" placeholder="Enter Sender City" id="sender_city" name="sender_city" required>
                                </div>
                                <div class="form-group col-md-4">
                                    <label class="form-label" for="receiver_city">Receiver City: <span class="text-danger">*</span></label>
                                    <input class="form-control" type="text" placeholder="Enter Receiver City" id="receiver_city" name="receiver_city" required>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-md-4">
                                    <label class="form-label" for="date">Date: <span class="text-danger">*</span></label>
                                    <input class="form-control" type="date" id="date" name="date" required>
                                </div>
                                <div class="form-group col-md-4">
                                    <label class="form-label" for="commission_paid_by">Commission Paid By: <span class="text-danger">*</span></label>
                                    <select class="form-control" name="commission_paid_by" id="commission_paid_by" required>
                                        <option value="Sender">Sender</option>
                                        <option value="Receiver">Receiver</option>
                                    </select>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-sm btn-primary">Add Transaction</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

</x-app-layout>

<!-- Load jQuery first -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- jQuery UI CSS -->
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">

<!-- jQuery UI Script -->
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>

<!-- Autocomplete Script -->
<script>
    $(function () {
        var cities = [
            "Ahmedabad", "Agra", "Ajmer", "Aligarh", "Allahabad", "Amritsar",
            "Bangalore", "Bhopal", "Bhubaneswar", "Chandigarh", "Chennai",
            "Coimbatore", "Dehradun", "Delhi", "Faridabad", "Gandhinagar",
            "Ghaziabad", "Guwahati", "Hyderabad", "Indore", "Jaipur", "Jodhpur",
            "Kanpur", "Kochi", "Kolkata", "Lucknow", "Ludhiana", "Meerut",
            "Mumbai", "Mysore", "Nagpur", "Nashik", "Noida", "Patna", "Pune",
            "Raipur", "Rajkot", "Ranchi", "Surat", "Thane", "Udaipur", "Vadodara",
            "Varanasi", "Vijayawada", "Visakhapatnam"
        ];

        $("#sender_city, #receiver_city").autocomplete({
            source: function(request, response) {
                var term = request.term.toLowerCase(); // Convert input to lowercase
                var filteredResults = $.grep(cities, function(city) {
                    return city.toLowerCase().startsWith(term); // Match from start
                });
                response(filteredResults);
            }
        });
    });
</script>
