<?php

use App\Http\Controllers\AccountController;
use App\Http\Controllers\Auth\ApiAuthController;
use App\Http\Controllers\CommissionController;
use App\Http\Controllers\Controller;
use App\Http\Controllers\MyCommissionController;
use App\Http\Controllers\PartiesCommissionController;
use App\Http\Controllers\PartiesController;
use App\Http\Controllers\ReportsController;
use App\Http\Controllers\SetCommissionController;
use App\Http\Controllers\TransactionController;
use App\Http\Controllers\UserController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::post('/login', [ApiAuthController::class, 'login']); // POST for login

// React Native API Start
Route::get('/users/{id}', [UserController::class, 'userShow']);
Route::post('/users/create', [UserController::class, 'store']);
Route::put('/users/{id}/update', [UserController::class, 'userUpdate']);
Route::delete('/users/{id}', [UserController::class, 'destroy']);

Route::get('/parties/{id}', [PartiesController::class, 'partyShow']);
Route::put('/parties/{id}/update', [PartiesController::class, 'partyUpdate']);
Route::post('/parties/create', [PartiesController::class, 'store']);
Route::delete('/parties/{id}', [PartiesController::class, 'destroy']);

Route::post('/transactions/create', [TransactionController::class, 'store']);
Route::delete('/transactions/{id}', [TransactionController::class, 'destroy']);

Route::get('/setcommissions/{id}', [SetCommissionController::class, 'setcommissionShow']);
Route::put('/setcommissions/{id}/update', [SetCommissionController::class, 'setcommissionUpdate']);
Route::post('/setcommissions/create', [SetCommissionController::class, 'store']);
Route::delete('/setcommissions/{id}', [SetCommissionController::class, 'destroy']);

Route::delete('/accounts/{id}', [AccountController::class, 'destroy']);
Route::post('/accounts/settle/{id}', [AccountController::class, 'settle'])->name('accounts.settle');
Route::delete('/commissions/bulk-destroy', [CommissionController::class, 'bulkDestroy'])->name('commissions.bulkDestroy');
Route::delete('/partiescommissions/bulk-destroy', [PartiesCommissionController::class, 'bulkDestroy'])->name('partiescommissions.bulkDestroy');
Route::delete('/mycommissions/bulk-destroy', [MyCommissionController::class, 'bulkDestroy'])->name('mycommissions.bulkDestroy');

Route::get('/total-users', [Controller::class, 'getTotalUsers']);
Route::get('/total-parties', [Controller::class, 'getTotalParties']);
Route::get('/total-commissions', [Controller::class, 'getTotalCommissions']);
Route::get('/total-mycommissions', [Controller::class, 'getTotalMyCommissions']);
// React Native API Ends

Route::middleware('auth:sanctum')->group(function () {
    Route::post('/logout', [ApiAuthController::class, 'logout']);
    // Route::get('/user', [ApiAuthController::class, 'user']);
    Route::resource('users', UserController::class);
    Route::resource('parties', PartiesController::class);
    Route::resource('accounts', AccountController::class);
    Route::resource('transactions', TransactionController::class);
    Route::resource('commissions', CommissionController::class);
    Route::resource('mycommissions', MyCommissionController::class);
    Route::resource('partiescommissions', PartiesCommissionController::class);
    Route::resource('setcommissions', SetCommissionController::class);
    Route::post('/reports/export-pdf', [ReportsController::class, 'exportPDF'])->name('reports.exportpdf');
    Route::post('/reports/export-excel', [ReportsController::class, 'exportExcelAPI'])->name('reports.exportExcel');
    Route::post('/reports/party-export-pdf', [ReportsController::class, 'exportpartyPDF'])->name('reports.partyexportpdf');
    Route::post('/reports/party-export-excel', [ReportsController::class, 'partyexportExcelAPI'])->name('reports.partyexportExcel');
    Route::get('/reports/partyindex', [ReportsController::class, 'partyindex'])->name('reports.partyindex');
    Route::resource('reports', ReportsController::class);
});
